/**
* \file: AilAudioSink.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*          J. Michalik / ADITG/SW1 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "AilAudioSink.h"
#include "AilAudioSinkImpl.h"

namespace adit { namespace aauto {

AilAudioSink::AilAudioSink(uint8_t inSessionId, MessageRouter* inMessageRouter) :
                AditAudioSink(inSessionId, inMessageRouter)
{
    impl = new AilAudioSinkImpl(this);
}

AilAudioSink::~AilAudioSink()
{
    /* This impl pointer is deleted at shared_ptr in callbak impl on GalReceiver */
}

bool AilAudioSink::init()
{
    return impl->init();
}
void AilAudioSink::shutdown()
{
    impl->shutdown();
}
void AilAudioSink::setConfigItem(string inKey, string inValue)
{
    return impl->setConfigItem(inKey, inValue);
}

void AilAudioSink::registerCallbacks(IAditAudioSinkCallbacks* inCallbacks)
{
    return impl->registerCallbacks(inCallbacks);
}

} } /* namespace adit { namespace aauto { */
